-- ----------------------
--    Basic cmd's v2
--   by:suicidal_banana
-- ----------------------

-- ----------------------
--    PLUGIN SETTINGS
-- ----------------------
slapItems = { "a large trout", "a pork-chop", "a fish", "some sharpened bamboo", "some wet wheat", "a floppy pink dildo" } 
errorColor = cChatColor.Red
meColor = cChatColor.Blue
msgColor = cChatColor.Gold
slapColor = cChatColor.Rose
whisperColor = cChatColor.Gold
shoutColor = cChatColor.Gold
whisperDist = 15
shoutDist = 30
logAll = true -- this logs all the commands in this plugin

debugMode = false -- keep this false so people cant slap message etc themselves
-- ----------------------

local BasicCmdsPlugin = {}
BasicCmdsPlugin.__index = BasicCmdsPlugin

-- ----------------------
--    Native functions
-- ----------------------
function BasicCmdsPlugin:new()
	local t = {}
	setmetatable(t, BasicCmdsPlugin)
	local w = Lua__cPlugin:new()
	tolua.setpeer(w, t)
	w:tolua__set_instance(w)
	return w
end

function BasicCmdsPlugin:OnDisable()
	Log( self:GetName() .. " v." .. self:GetVersion() .. " is shutting down..." )
end

function BasicCmdsPlugin:Initialize()
	self:SetName( "Basic cmds" )
	self:SetVersion( 2 )

	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager:AddHook( self, cPluginManager.E_PLUGIN_CHAT )

	self:AddCommand("/me [msg]", " - Share your thoughts!")
	self:AddCommand("/msg [name] [msg]", " - Send somebody a private message")
	self:AddCommand("/whisper [msg]", " - Whisper to nearby players (" .. whisperDist .. " blocks)")
	self:AddCommand("/shout [msg]", " - Shout to nearby players (" .. shoutDist .. " blocks)")
	self:AddCommand("/slap [name]", " - Slap someone!")

	Log( "Initialized " .. self:GetName() .. " v." .. self:GetVersion() )
	return true;
end

-- ----------------------
--    Helper functions
-- ----------------------
function trimStr(s)
	-- Straightforward trim function, googled somewhere
	
	local from = s:match"^%s*()"
	return from > #s and "" or s:match(".*%S", from)
end

function getPlayerByName( PartialName )	
	-- Searches entire string instead of only from the start
	-- 'Rates' names; the shorter a matched name is, the higher
	-- the propability the user meant that person.
	
	PlayerList = World:GetAllPlayers()

	FoundPlayer = nil
	LastRating = 100
	
	for i, TestPlayer in ipairs( PlayerList ) do
		-- TestPlayer = Player:GetPlayer()
		TestPlayerName = TestPlayer:GetName()
			
		if(string.find(TestPlayerName, PartialName) ~= nil) then
			if(string.len(TestPlayerName) < LastRating) then
				FoundPlayer = TestPlayer
				LastRating = string.len(TestPlayerName)
			end
		end
	end
	return FoundPlayer
end


-- ----------------------
--     Chat commands
-- ----------------------
function BasicCmdsPlugin:OnChat( Message, Player )
	if( GetChar(Message, 0) ~= '/' ) then -- Not a command
		return false
	end
		
	-- Vars
	Server = cRoot:Get():GetServer()
	PlayerName = Player:GetName()
	World = cRoot:Get():GetWorld()
	Split = StringSplit(Message, " ")
	
	-- me cmd
	if(Split[1] == "/me") then
		if((#Split < 2) or (trimStr(string.sub(Message,4)) == "")) then
			Message = errorColor .. "/me [msg] - You need too supply a message!"
			Server:SendMessage( Message, Player )
			return true
		end
	
		Message = PlayerName .. " " .. trimStr(string.sub(Message,4))
		if(logAll) then Log( "[ME] " .. Message ) end
		Message = meColor .. Message
		Server:SendMessage( Message )
		return true
	end
	
	-- msg cmd
	if(Split[1] == "/msg") then
		if((#Split < 3) or (trimStr(Split[2]) == "") or (trimStr(Split[3]) == "")) then
			Message = errorColor .. "/msg [name] [msg] - You need too supply a name & msg"
			Server:SendMessage( Message, Player )
			return true
		end
		
		FullMsg = ""
		for i,v in ipairs(Split) do
			if(i>2) then
				if(FullMsg == "") then
					FullMsg = v
				else
					FullMsg = FullMsg .. " " .. v
				end	
			end
		end
		
		OtherPlayer = getPlayerByName(trimStr(Split[2]))
		if(OtherPlayer == nil) then
			Message = errorColor .. "Can't find " .. trimStr(Split[2])
			Server:SendMessage( Message, Player )
		elseif((OtherPlayer == Player) and (debugMode == false)) then
			Message = errorColor .. "You can't message yourself!"
			Server:SendMessage( Message, Player )
		else
			Message = "[MSG] " .. PlayerName .. ": " .. FullMsg
			if(logAll) then Log( Message ) end
			Message = msgColor .. Message
			Server:SendMessage( Message, OtherPlayer )
			Server:SendMessage( Message, Player )
		end
		return true
	end
	
	-- whisper cmd
	if(Split[1] == "/whisper") then
		if((#Split < 2) or (trimStr(Split[2]) == "")) then
			Message = errorColor .. "/whisper [msge] - You need too supply a msg"
			Server:SendMessage( Message, Player )
			return true
		end
		
		PlayerList = World:GetAllPlayers()
		FullMsg = trimStr(string.sub(Message,9))
				
		Message = PlayerName .. " whispers: " .. FullMsg
		if(logAll) then Log( "[WHISPER] " .. Message ) end
		Message = whisperColor .. Message
		
		for i, OtherPlayer in ipairs( PlayerList ) do
			TestPlayerDist = (OtherPlayer:GetPosition() - Player:GetPosition()):Length()
			if(TestPlayerDist < whisperDist) then
				Server:SendMessage( Message, OtherPlayer )
			end
		end
		return true
	end
	
	-- shout cmd
	if(Split[1] == "/shout") then
		if((#Split < 2) or (trimStr(Split[2]) == "")) then
			Message = errorColor .. "/shout [msg] - You need too supply a msg"
			Server:SendMessage( Message, Player )
			return true
		end
		
		PlayerList = World:GetAllPlayers()
		FullMsg = trimStr(string.sub(Message,7))
				
		Message = PlayerName .. " shouts: " .. FullMsg
		if(logAll) then Log( "[SHOUT] " .. Message ) end
		Message = whisperColor .. Message
		
		for i, OtherPlayer in ipairs( PlayerList ) do
			TestPlayerDist = (OtherPlayer:GetPosition() - Player:GetPosition()):Length()
			if(TestPlayerDist < shoutDist) then
				Server:SendMessage( Message, OtherPlayer )
			end
		end
		return true
	end

	-- slap cmd
	if(Split[1] == "/slap") then
		if((#Split < 2) or (trimStr(Split[2]) == "")) then
			Message = errorColor .. "/slap [name] - You need too supply a name"
			Server:SendMessage( Message, Player )
			return true
		end

		OtherPlayer = getPlayerByName(trimStr(Split[2]))
		if(OtherPlayer == nil) then
			Message = errorColor .. "Can't find " .. trimStr(string.sub(Message,6))
			Server:SendMessage( Message, Player )
		elseif((OtherPlayer == Player) and (debugMode == false)) then
			Message = errorColor .. "You can't slap yourself!"
			Server:SendMessage( Message, Player )
		else
			subPlayerName = OtherPlayer:GetName()
			Message = PlayerName .. " slaps " .. subPlayerName .. " around with " .. slapItems[math.random(1,#slapItems)] .. "."
			if(logAll) then Log( "[SLAP] " .. Message ) end
			Message = slapColor .. Message
			Server:SendMessage( Message )
		end
		return true
	end
	

	return false
end

Plugin = BasicCmdsPlugin:new()
cRoot:Get():GetPluginManager():AddPlugin( Plugin )
