PLUGIN = {}
local isAuth = {}
local authName = {}
local pluginCallList = {}
local rndGuest

function Initialize( Plugin )
	PLUGIN = Plugin
	
	Plugin:SetName( "tAuthentication" )
	Plugin:SetVersion( 1 )
    
    
    PluginManager = cRoot:Get():GetPluginManager()
    PluginManager:AddHook(Plugin, cPluginManager.HOOK_LOGIN)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_JOINED)
    PluginManager:AddHook(Plugin, cPluginManager.HOOK_DISCONNECT)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_PLACING_BLOCK)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_BREAKING_BLOCK)
    PluginManager:AddHook(Plugin, cPluginManager.HOOK_TAKE_DAMAGE)
    PluginManager:AddHook( Plugin, cPluginManager.HOOK_PLAYER_SPAWNED )
	
	
	PluginManager:BindCommand("/register",            "auth.register",            authRegister,            " - Register your account");
	PluginManager:BindCommand("/login",            "auth.login",            authLogin,            " - Logs you into your account");
    rndGuest = math.random(100,500)
	LOG( "Initialized " .. Plugin:GetName() .. " v." .. Plugin:GetVersion() )
	return true
end

function addPlugin( PluginName )
    table.insert( pluginCallList, PluginName )
end

function authRegister( Split, Player )

	while(isAuth[authName[Player:GetName()]] == true) do
		Player:SendMessage( "USE /register [password]")
	end
    IniFile = cIniFile(PLUGIN:GetLocalDirectory() .. "/users.ini")
    if(#Split < 2) then
        Player:SendMessage( "Usage: /register [password]." )
    elseif(isAuth[authName[Player:GetName()]] == true) then
        Player:SendMessage( "Your already logged in." )
    else
        IniFile:ReadFile()
        local password = IniFile:GetValueSet(authName[Player:GetName()], "password", "" )
        if(password == "") then
            IniFile:SetValue(authName[Player:GetName()], "password", md5(Split[2]) ,false)
            IniFile:WriteFile()
            Player:SendMessage( "Your username is now registerd." )
        else
            Player:SendMessage( "This username is already registerd." )
        end
    end
    return true
end

function authLogin( Split, Player )
    IniFile = cIniFile(PLUGIN:GetLocalDirectory() .. "/users.ini")
    if(#Split < 2) then
        Player:SendMessage( "Usage: /login [password]." )
    elseif(isAuth[authName[Player:GetName()]] == true) then
        Player:SendMessage( "Your already logged in." )
    else
        IniFile:ReadFile()
        local password = IniFile:GetValueSet(authName[Player:GetName()], "password", "" )
        if(password == "") then
            Player:SendMessage( "This account has no password set." )
        elseif(password == md5(Split[2])) then
            Player:SetName(authName[Player:GetName()])
            isAuth[Player:GetName()] = true
            Player:LoadPermissionsFromDisk()
            Player:SendMessage( "You are now logged in." )
            function callPlugins(_index)
                local addPlugin = PluginManager:GetPlugin( pluginCallList[_index] )
                addPlugin:Call("PlayerAuthenticated", Player )
            end
            table.foreach( pluginCallList, callPlugins )
        else
            Player:SendMessage( "You have enterd a incorrect password." )
        end
    end
    return true
end

function OnDisconnect( Player, Reason )
    isAuth[Player:GetName()] = false
end

function OnLogin(Client, ProtocolVersion, Username)
    local skipAuth = false
    --local ClientHandle = Player:GetClientHandle()
    local loopPlayers = function( PlayerNew )
        if(PlayerNew:GetName() == Username) then
            PlayerNew:SendMessage( "Somebody just tried to login in under your name." )
            Client:Kick( "[Server] Already ingame." )
            skipAuth=true
        end
    end
    local loopWorlds = function ( World )
        World:ForEachPlayer( loopPlayers )
    end
    end

function OnPlayerSpawned( Player )

end

function OnPlayerJoined( Player )

    --if(isAuth[Player:GetName()] == false) then
        Player:RemoveFromGroup("Default")
        Player:AddToGroup("Guest")
    --end
    return false
end

function OnTakeDamage( Pawn, TDI )
   --if not (isAuth[Pawn:GetName()]) then
      --TDI.Damage = 0
   --else
      --return false
   --end
end

function OnPlayerBreakingBlock(Player, BlockX, BlockY, BlockZ, BlockFace, OldBlockType, OldBlockMeta)

	if (isAuth[Player:GetName()]) then
		return false
	else
        Player:SendMessage( "Please login before you start digging." )
        return true
    end
end

function OnPlayerPlacingBlock(Player, BlockX, BlockY, BlockZ, BlockFace, cx, cy, cz, oldblock, meta)

    if (isAuth[Player:GetName()]) then
		return false
	else
        Player:SendMessage( "Please login before you try placing blocks." )
        return true
    end

end

function OnDisable()
    local loopPlayers = function( Player )
        local ClientHandle = Player:GetClientHandle()
        ClientHandle:Kick( "[Server] Reloading." )
    end
    local loopWorlds = function ( World )
        World:ForEachPlayer( loopPlayers )
    end
    cRoot:Get():ForEachWorld( loopWorlds )
end
