function Initialize(Plugin)
	local Server = cRoot:Get():GetServer()
	PLUGIN = Plugin
    Plugin:SetName( "banip" )
    Plugin:SetVersion( 1 )
	
	PluginManager = cRoot:Get():GetPluginManager()
    PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_JOINED)

	
	PluginManager:BindCommand("/banip", 	"banip.ban", 		HandleBanIPCommand, 		" - ban the ip of a player");
	PluginManager:BindCommand("/unbanip",   "banip.unban",  	HandleUnbanIPCommand,	 	" - unban the ip of a player");
	PluginManager:BindCommand("/ip",		"banip.ip",			HandleIPCommand, 			" - Shows the IP of a player");
	
	InitConsoleCommands()
	LOG("Initialized " .. PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion())
	PluginDir = Plugin:GetLocalDirectory() .. "/"
	return true
end


function InitConsoleCommands()
	local PluginMgr = cPluginManager:Get();
	PluginMgr:BindConsoleCommand("banip",              	 HandleConsoleBanIP,              	"[Player] - Ban a IP");
	PluginMgr:BindConsoleCommand("unbanip",              	 HandleConsoleUnbanIP,              	"[Player] - Unban a IP");
	PluginMgr:BindConsoleCommand("ip",					HandleConsoleIP,		"[Player] - Gets the IP");
end

function HandleConsoleIP(Split, Player)
	IPD = io.open(PluginDir .. "IP/" .. Split[2])
	if IPD then
		IP = (io.lines(PluginDir .. "IP/" .. Split[2]))	
		LOGINFO("The IP You are looking for is " .. IP());
		return true
	else
		LOGINFO("Player not found")
	return true
	end
end

function HandleIPCommand(Split, Player)
	if Split[2] == nil then
		Player:SendMessage(cChatColor.Rose .. "Usage: /ip (player)")
		return true
	else
	IPD = io.open(PluginDir .. "IP/" .. Split[2])
	if IPD then
		IP = (io.lines(PluginDir .. "IP/" .. Split[2]))	
		Player:SendMessage(cChatColor.Green .. "The IP You are looking for is " .. IP());
		return true
	else
		Player:SendMessage(cChatColor.Green .. "Player not found")
	return true
	end
end
end
function HandleBanIPCommand( Split, Player, Plugin )
	if( #Split < 2 ) then
		Player:SendMessage( cChatColor.Green .. "Usage: /banip [IP]" )
		return true
	end
	if not(PluginDir .. "/" .. "Bans") then
		os.execute('MKDIR "' .. PluginDir .. "/" .. "Bans")
	end
	MyFile = io.open(PluginDir .. "Bans/" .. Split[2], 'w')
	LOG(PluginDir .. "Bans/" .. Split[2])
	if not MyFile then 
	print('Ban failed. please check if the server has the right to create files'); 
	return true; 
	else
		Player:SendMessage( cChatColor.Rose .. Split[2] .. " is banned")
	end
	MyFile:close()
	LOGINFO("IP " .. Split[2] .. " is banned")
	return true
end


function HandleConsoleBanIP( Split, Player, Plugin )
	if( #Split < 2 ) then
		LOGINFO( "Usage: /banip [IP]" )
		return true
	end
	if not(PluginDir .. "/" .. "Bans") then
		os.execute('MKDIR "' .. PluginDir .. "/" .. "Bans")
	end
	MyFile = io.open(PluginDir .. "Bans/" .. Split[2], 'w')
	if not MyFile then 
	print('Ban failed. please check if the server has the right to create files'); 
	return true; 
	else
		LOGINFO("IP " .. Split[2] .. " is banned")
	end
	MyFile:close()
	return true
end


function HandleConsoleUnbanIP( Split )
	if (#Split < 2 ) then
		LOGINFO( "Usage: /unbanip [IP]")
		return true
	end
	IPDirectory = (PluginDir .. "Bans/" .. Split[2])
		if not IPDirectory then
	LOGINFO("IP not found")
	end
	os.remove(IPDirectory)
	if os.remove( IPDirectory ) == true then
		LOGINFO("Unban failed")
	else
		LOGINFO(Split[2] .. " is unbanned")
	end
	return true
end

function HandleUnbanIPCommand( Split, Player )
	if (#Split < 2 ) then
		Player:SendMessage( cChatColor.Green .. "Usage: /unbanip [IP]")
		return true
	end
	IPDirectory = (PluginDir .. "Bans/" .. Split[2])
	if not (IPDirectory) then
	Player:SendMessage("IP not found")
	end
	os.remove( IPDirectory )
	LOGINFO(Split[2] .. " is unbanned")
	Player:SendMessage(Split[2] .. " is unbanned")
	return true
end

function OnPlayerJoined(Player)
	IPDir = io.open(PluginDir .. "Bans/" .. Player:GetIP())
	if IPDir then
		IPDir:close()
		LOG("BANNED")
		local ClientHandle = Player:GetClientHandle()
		ClientHandle:Kick( "YOU ARE BANNED. STAY AWAY!" )
		i = 1
		repeat
		i = i + 1
		Player:SendMessage(cChatColor.Red ..  "YOU ARE BANNED. STAY AWAY!" )
		until i == 20
	end
	PDIP = io.open(PluginDir .. "IP/" .. Player:GetName(), "w")
	if not PDIP then 
	LOGWARN('No IP Found'); 
	return true; 
	else
		PDIP:write(Player:GetIP())
	end
	PDIP:close()
end