--[[JumpTo
	Original Author: Kwen
	Updated by: STR_Warrior
  ]]
--SETTINGS--

	ShowMessage = false -- If true you get a message when you teleport
	ShowConsoleMessage = false -- If true you get a message in the console when someone teleports using Jumpto
	Activateonlogin = true -- If true you can automaticly (if you have the permission) use it without using /jumpto

--SETTINGS--


Compass = {}

function Initialize(Plugin)
	PLUGIN = Plugin;
	
	Plugin:SetName("JumpTo");
	Plugin:SetVersion(7);
	
	PluginManager = cRoot:Get():GetPluginManager();
	cPluginManager:Get():AddHook(Plugin, cPluginManager.HOOK_PLAYER_USING_ITEM);
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_JOINED);
	
	PluginManager:BindCommand("/jumpto",            "Jumpto.jump",            Jumpto,            " - Enables\Disables Compass jumping");
	LOG("Initialized " .. PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion())
	return true;
end

function OnPlayerJoined(Player)
	if (Player:HasPermission("Jumpto.jump") == true) then
		Compass[Player:GetName()] = {}
		Compass[Player:GetName()].UseCompass = Activateonlogin
	end
end
		
function Jumpto(Split, Player)
	if (Player:HasPermission("Jumpto.jump") == true) then
		if (Compass[Player:GetName()].UseCompass == false) then
			Compass[Player:GetName()].UseCompass = true
			Player:SendMessage( cChatColor.Green .. "You can now use a compass to teleport around")
		else
			Compass[Player:GetName()].UseCompass = false
			Player:SendMessage( cChatColor.Green .. "Compass teleport is disabled")
		end
	end
	return true
end

function OnDisable()
	LOG(PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion() .. " is shutting down...")
end