function HandleToggleCommand(Split, Player)
	if (Player:HasPermission("portal.create") == true) then
		if (PlayersData[Player:GetName()] == nil) then
			PlayersData[Player:GetName()] = {}	-- create player's page
		end
		if (PlayersData[Player:GetName()].create_volume_mode == nil) then
			PlayersData[Player:GetName()].create_volume_mode = true
		end
		if (PlayersData[Player:GetName()].create_volume_mode == false) then
			PlayersData[Player:GetName()].create_volume_mode = true
			Player:SendMessage("Your wooden sword will now select portal entrance zone")
		else
			PlayersData[Player:GetName()].create_volume_mode = false
			Player:SendMessage("Your wooden sword will now act as usual")
		end
	end
	SavePlayersData()
	return true
end
--\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
function HandleMakeWarpCommand(Split, Player)
	if (Player:HasPermission("portal.create") == true) then
		if (#Split == 2) then
			if (PortalsData.warps[Split[2]] == nil) then
				PortalsData.warps[Split[2]] = {}	-- we create a new warp note
				PortalsData.warps[Split[2]].world_name = Player:GetWorld():GetName()
				PortalsData.warps[Split[2]].point = Vector3d()
				PortalsData.warps[Split[2]].point.x = Player:GetPosX()
				PortalsData.warps[Split[2]].point.y = Player:GetPosY()
				PortalsData.warps[Split[2]].point.z = Player:GetPosZ()
				Player:SendMessage('Warp "'..Split[2]..'" created!')
				
				CheckLinkage(true, Split[2], Player)
				SavePortalsData()
			else
				Player:SendMessage('There already is a warp, named "'..Split[2]..'"')
			end
		else
			Player:SendMessage("You should specify the name in one word")
		end
	else
		Player:SendMessage("You're not allowed to create warps")
	end
	return true
end

function HandleMakeEnterCommand(Split, Player)
	if (Player:HasPermission("portal.create") == true) then
		if (#Split == 2) then
			if (PlayersData[Player:GetName()].point1 ~= nil) then
				if (PlayersData[Player:GetName()].point2 ~= nil) then
					if (PortalsData.enters[Split[2]] == nil) then
						PortalsData.enters[Split[2]] = {}	-- we create a new enter note
						PortalsData.enters[Split[2]].world_name = Player:GetWorld():GetName()
						PortalsData.enters[Split[2]].point1 = Vector3i()
						PortalsData.enters[Split[2]].point2 = Vector3i()
						PortalsData.enters[Split[2]].point1.x = PlayersData[Player:GetName()].point1.x
						PortalsData.enters[Split[2]].point1.y = PlayersData[Player:GetName()].point1.y
						PortalsData.enters[Split[2]].point1.z = PlayersData[Player:GetName()].point1.z
						PortalsData.enters[Split[2]].point2.x = PlayersData[Player:GetName()].point2.x
						PortalsData.enters[Split[2]].point2.y = PlayersData[Player:GetName()].point2.y
						PortalsData.enters[Split[2]].point2.z = PlayersData[Player:GetName()].point2.z
						Player:SendMessage('Entrance "'..Split[2]..'" created!')
						
						CheckLinkage(false, Split[2], Player)
						SavePortalsData()
					else
						Player:SendMessage('There already is an entrance, named "'..Split[2]..'"')
					end
				else
					Player:SendMessage("You haven't specified the portal entrance zone!")
				end
			end
		else
			Player:SendMessage("You should specify the name in one word")
		end
	else
		Player:SendMessage("You're not allowed to create portals")
	end
	return Content
end
--\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
function SavePortalsData()
	file = io.open("portals_portals.dat", "w+")
	for k,v in pairs(PortalsData.warps) do
		local line = ""
		line = k.."~"..v.world_name.."~"..v.point.x.."~"..v.point.y.."~"..v.point.z
		file:write(line.."\n")
	end
	for k,v in pairs(PortalsData.enters) do
		local line = ""
		line = k.."~"..v.world_name.."~"..v.point1.x.."~"..v.point1.y.."~"..v.point1.z
		line = line.."~"..v.point2.x.."~"..v.point2.y.."~"..v.point2.z
		file:write(line.."\n")
	end
	file:close()
	LOG("Portals data is saved")
end
function SavePlayersData()
	file = io.open("portals_players.dat", "w+")
	for k,v in pairs(PlayersData) do
		if (v.create_volume_mode ~= nil) then
			local line = ""
			line = k.."~"..BoolToString(v.create_volume_mode)
			file:write(line.."\n")
		end
	end
	file:close()
	LOG("Players data is saved")
end
function LoadPortalsData()
	file = io.open("portals_portals.dat", "r")
	if file==nil then return 1 end
	for line in file:lines() do
		Split = SplitFileLine(line)
		-- split validation!!!
		if (#Split == 5) then
			-- WARP!
			if (cRoot:Get():GetWorld(Split[2]) ~= nil) then
				if (PortalsData.warps[Split[1]] == nil) then
					PortalsData.warps[Split[1]] = {}	-- create page
				end
				PortalsData.warps[Split[1]].world_name = Split[2]
				
				PortalsData.warps[Split[1]].point = Vector3d()
				PortalsData.warps[Split[1]].point.x = Split[3]
				PortalsData.warps[Split[1]].point.y = Split[4]
				PortalsData.warps[Split[1]].point.z = Split[5]
			else
				LOG('There is a warp "'..Split[1]..'" in removed/deleted world "'..Split[2]..'"!')
			end
		end
		if (#Split == 8) then
			-- ENTER!
			if (cRoot:Get():GetWorld(Split[2]) ~= nil) then
				if (PortalsData.enters[Split[1]] == nil) then
					PortalsData.enters[Split[1]] = {}	-- create page
				end
				PortalsData.enters[Split[1]].world_name = Split[2]
				
				PortalsData.enters[Split[1]].point1 = Vector3i()
				PortalsData.enters[Split[1]].point1.x = Split[3]
				PortalsData.enters[Split[1]].point1.y = Split[4]
				PortalsData.enters[Split[1]].point1.z = Split[5]
				
				PortalsData.enters[Split[1]].point2 = Vector3i()
				PortalsData.enters[Split[1]].point2.x = Split[6]
				PortalsData.enters[Split[1]].point2.y = Split[7]
				PortalsData.enters[Split[1]].point2.z = Split[8]
				
				CheckLinkage(false, Split[1], false)
			else
				LOG('There is an enter "'..Split[1]..'" in removed/deleted world "'..Split[2]..'"!')
			end
		end
	end
	file:close()
end
function LoadPlayersData()
	file = io.open("portals_players.dat", "r")
	if file==nil then return 1 end
	for line in file:lines() do
		Split = SplitFileLine(line)
		-- split validation!!!
		if (#Split == 2) then
			-- consolidation
			if (PlayersData[Split[1]] == nil) then
				PlayersData[Split[1]] = {}	-- create player's page
			end
			PlayersData[Split[1]].create_volume_mode = StringToBool(Split[2])
		end
	end
	file:close()
end
--\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
function CheckLinkage(ForWarp, CheckName, Player)
	if (Player ~= false) then
		if (ForWarp) then
			if (PortalsData.enters[CheckName] == nil) then
				Player:SendMessage("Now you should create portal entrance")
			else
				PortalsData.enters[CheckName].linked = true
				Player:SendMessage('Portal "'..CheckName..'" is linked!')
				LOG('Portal "'..CheckName..'" is linked!')
			end
		else
			if (PortalsData.warps[CheckName] == nil) then
				Player:SendMessage("Now you should mark portal warp point")
			else
				PortalsData.enters[CheckName].linked = true
				Player:SendMessage('Portal "'..CheckName..'" is linked!')
				LOG('Portal "'..CheckName..'" is linked!')
			end
		end
	else
		if (ForWarp) then
			if (PortalsData.enters[CheckName] ~= nil) then
				PortalsData.enters[CheckName].linked = true
				LOG('Portal "'..CheckName..'" is linked!')
			end
		else
			if (PortalsData.warps[CheckName] ~= nil) then
				PortalsData.enters[CheckName].linked = true
				LOG('Portal "'..CheckName..'" is linked!')
			end
		end
	end
end
--\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
function FindZone(Player)
	local _check_cuboid = cCuboid()
	local _player_pos = Player:GetPosition()
	_player_pos.x = math.floor(_player_pos.x)
	_player_pos.y = math.floor(_player_pos.y)
	_player_pos.z = math.floor(_player_pos.z)
	for k,v in pairs(PortalsData.enters) do
		if (v.linked) then
			if (v.world_name == Player:GetWorld():GetName()) then
				_check_cuboid.p1 = v.point1
				_check_cuboid.p2 = v.point2
				_check_cuboid:Sort()
				if (_check_cuboid:IsInside(_player_pos)) then
					return k
				end
			end
		end
	end
	return false
end
--\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
function round(x)
  if (x%2 ~= 0.5) then
    return math.floor(x+0.5)
  end
  return x-0.5
end

function SplitFileLine(line)
	local splt = {}
	for w in string.gmatch(line, "[^~]+") do
		table.insert(splt, w)
	end
	return splt
end

function StringToBool(value)
	if value=="1" then return true end
	return false
end

function BoolToString(value)
	if value==true then return 1 end
	return 0
end