-- Global variables
PLUGIN = {}	-- Reference to own plugin object
-- LOGIC
PORTAL_ACTIVATION_TIME = 2
PlayersData = {}	-- this would be a hashtable for players not-moving times and admins enable/disable modes
PortalsData = {}
	PortalsData.warps = {}
	PortalsData.enters = {}

function Initialize(Plugin)
	PLUGIN = Plugin
	PLUGIN:SetName("Portal")
	PLUGIN:SetVersion(1)
	
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager:AddHook(PLUGIN, cPluginManager.HOOK_PLAYER_MOVING)
	PluginManager:AddHook(PLUGIN, cPluginManager.HOOK_PLAYER_PLACING_BLOCK)	-- for admin purpose only - to create portal entrance zones
	PluginManager:AddHook(PLUGIN, cPluginManager.HOOK_PLAYER_BREAKING_BLOCK)	-- for admin purpose only - to create portal entrance zones
	
	PluginManager:BindCommand("/ptoggle",	"portal.create",	HandleToggleCommand,   		" - switches volume selection mode")
	PluginManager:BindCommand("/pwarp",	"portal.create",	HandleMakeWarpCommand,		" (name) - creates warp point with given name")
	PluginManager:BindCommand("/penter",	"portal.create",	HandleMakeEnterCommand,		" (name) - creates portal volume out of selection and associates it with given warp")
	
	Plugin:AddWebTab("Portals", HandleRequest_Portals)
	
	LoadPortalsData()
	LoadPlayersData()
	LOG("Initialized " .. PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion())
	return true
end

function OnDisable()
	SavePortalsData()
	SavePlayersData()
	LOG(PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion() .. " is shutting down...")
end

function OnPlayerMoving(Player)
	local _name = Player:GetName()
	if (PlayersData[_name] == nil) then
		PlayersData[_name] = {}	-- create player's page
	end
	if (PlayersData[_name].portal_state == nil) then
		PlayersData[_name].portal_state = -1
	end
	local _zone = FindZone(Player)
	if (_zone ~= false) then
		if (PlayersData[_name].portal_state == -1) then
			Player:SendMessage("Stand still for "..PORTAL_ACTIVATION_TIME.." seconds for teleportation")
			PlayersData[_name].portal_state = 1
		end
		if (os.clock() > PlayersData[_name].portal_timer) then
			-- TELEPOOOOOORT!!!!!!1111
			if (Player:GetWorld():GetName() ~= PortalsData.warps["".._zone].world_name) then
				Player:MoveToWorld(PortalsData.warps["".._zone].world_name)
			end
			Player:TeleportTo(PortalsData.warps["".._zone].point.x, PortalsData.warps["".._zone].point.y, PortalsData.warps["".._zone].point.z)
			Player:SendMessage("You have been teleported!")
			PlayersData[_name].portal_state = -1
			PlayersData[_name].portal_timer = os.clock() + PORTAL_ACTIVATION_TIME
		end
	else
		PlayersData[_name].portal_timer = os.clock() + PORTAL_ACTIVATION_TIME
		if (PlayersData[_name].portal_state == 1) then
			Player:SendMessage("You have left teleportation zone")
			PlayersData[_name].portal_state = -1
		end
	end
    return false
end

-- LEFTCLICK!
function OnPlayerBreakingBlock(Player, IN_x, IN_y, IN_z, BlockFace, Status, OldBlock, OldMeta)
	local _name = Player:GetName()
	if (PlayersData[_name] == nil) then
		PlayersData[_name] = {}	-- create player's page
	end
	if (Player:HasPermission("portal.create") == true) then
		if (PlayersData[Player:GetName()].create_volume_mode == nil) then
			PlayersData[Player:GetName()].create_volume_mode = true
		end
	end
	if (PlayersData[_name].create_volume_mode ~= nil) then
		if (PlayersData[_name].create_volume_mode == true) then
			if (Player:GetEquippedItem().m_ItemID == E_ITEM_WOODEN_SWORD) then
				if (PlayersData[_name].point1 == nil) then
					PlayersData[_name].point1 = Vector3i()
				end
				PlayersData[_name].point1.x = IN_x
				PlayersData[_name].point1.y = IN_y
				PlayersData[_name].point1.z = IN_z
				Player:SendMessage("First portal entrance volume point selected at: ("..IN_x..","..IN_y..","..IN_z..")")
				return true
			end
		end
	end
	return false
end

-- RIGHTCLICK!
function OnPlayerPlacingBlock(Player, IN_x, IN_y, IN_z, BlockFace, HeldItem)
	if (IN_x ~= -1 and IN_y ~= 255 and IN_z ~= -1) then
		local _name = Player:GetName()
		if (PlayersData[_name] == nil) then
			PlayersData[_name] = {}	-- create player's page
		end
		if (Player:HasPermission("portal.create") == true) then
			if (PlayersData[Player:GetName()].create_volume_mode == nil) then
				PlayersData[Player:GetName()].create_volume_mode = true
			end
		end
		if (PlayersData[_name].create_volume_mode ~= nil) then
			if (PlayersData[_name].create_volume_mode == true) then
				if (Player:GetEquippedItem().m_ItemID == E_ITEM_WOODEN_SWORD) then
					if (PlayersData[_name].point2 == nil) then
						PlayersData[_name].point2 = Vector3i()
					end
					PlayersData[_name].point2.x = IN_x
					PlayersData[_name].point2.y = IN_y
					PlayersData[_name].point2.z = IN_z
					Player:SendMessage("Second portal entrance volume point selected at: ("..IN_x..","..IN_y..","..IN_z..")")
					return true
				end
			end
		end
	end
	return false
end