
function Initialize( Plugin )
	Inspect = {}
	PLUGIN = Plugin
	Plugin:SetName( "BlockerLogger" )
	Plugin:SetVersion( 1 )
       
	PluginManager = cRoot:Get():GetPluginManager()

	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_PLACED_BLOCK)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_BROKEN_BLOCK)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_PLACING_BLOCK)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_BREAKING_BLOCK)
	
	PluginManager:BindCommand("/inspect", 		"blocklog.inspect", 	HandleBlockLogInspect,		" - a way to find out who broke/placed a block");

	Block = cIniFile(PLUGIN:GetLocalDirectory() .."/Blocks.ini")
	
	LoadSettings()
	LOG( "Initialized " .. Plugin:GetName() .. " v" .. Plugin:GetVersion() )
	return true
end

function HandleBlockLogInspect( Split, Player )
	if (Inspect[Player:GetName()] == nil) then
		Inspect[Player:GetName()] = true
		Player:SendMessage(cChatColor.LightGreen .. "Inspect mode is on")
	elseif Inspect[Player:GetName()] == false then
		Inspect[Player:GetName()] = true
		Player:SendMessage(cChatColor.LightGreen .. "Inspect mode is on")
	elseif Inspect[Player:GetName()] == true then
		Inspect[Player:GetName()] = false
		Player:SendMessage(cChatColor.LightGreen .. "Inspect mode is off")
	end
	return true
end