function Initialize(Plugin)
	PLUGIN = Plugin
	
	Plugin:SetName("T&C")
	Plugin:SetVersion( 1 )
	
	PluginManager = cRoot:Get():GetPluginManager()

	PluginManager:AddHook(Plugin, cPluginManager.HOOK_BLOCK_TO_PICKUPS)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_TAKE_DAMAGE)
	PluginManager:AddHook(Plugin, cPluginManager.HOOK_PLAYER_BROKEN_BLOCK);
	return true
end

function OnBlockToPickups(World, Digger, BlockX, BlockY, BlockZ, BlockType, BlockMeta, Pickups)
	if BlockType == 46 then
		Pickups:Clear()
		return true
	end
end
function OnTakeDamage(Receiver, TDI)
	if TDI.Attacker ~= nil and TDI.Attacker:IsA("cCreeper") then
		local X = TDI.Attacker:GetPosX()
		local Y = TDI.Attacker:GetPosY()
		local Z = TDI.Attacker:GetPosZ()
		World = TDI.Attacker:GetWorld()
		Radius = 3
		Material = 0
		Entf = 0
		ExplodeCreeper(X, Y, Z, TDI)
		i = 0
		local loopPlayers = function( Player )
			while i < DistanceCreeper(Receiver, TDI) do
				i = i + 0.5
				Receiver:TakeDamage( Receiver )
			end
		end
		World:ForEachPlayer( loopPlayers )
		TDI.Attacker:Destroy()
	end
end

function OnPlayerBrokenBlock(Player, BlockX, BlockY, BlockZ, BlockFace, BlockType, BlockMeta)
	if BlockType == 46 then
		Radius = 4
		World = Player:GetWorld()
		ExplodeTNT( BlockX, BlockY, BlockZ, BlockX, BlockY, BlockZ )
		i = 0
		local loopPlayers = function( Player )
			while i < DistanceTNT(Player, BlockX, BlockY, BlockZ) do
				i = i + 0.5
				Player:TakeDamage( Player )
			end
		end
		World:ForEachPlayer( loopPlayers )
		
	end
end


function ExplodeTNT( XC, YC, ZC, BlockX, BlockY, BlockZ )
      for XC = -Radius, Radius do
	     for YC = -Radius, Radius do
		   for ZC = -Radius, Radius do
			   Entf = XC*XC + YC*YC + ZC*ZC
			     if Entf < Radius*Radius then
					    if World:GetBlock( BlockX + XC, BlockY + YC, BlockZ + ZC ) ~= 7 and World:GetBlock( BlockX + XC, BlockY + YC, BlockZ + ZC ) ~= 49 and World:GetBlock( BlockX + XC, BlockY + YC, BlockZ + ZC ) ~= 9 and World:GetBlock( BlockX + XC, BlockY + YC, BlockZ + ZC ) ~= 8 then
					       World:DigBlock( BlockX + XC, BlockY + YC, BlockZ + ZC )
						end
				 end
		   end
	    end
     end
end 

function DistanceTNT(Receiver, BlockX, BlockY, BlockZ)
	A = BlockX + BlockY + BlockZ
	R = Receiver:GetPosX() + Receiver:GetPosY() + Receiver:GetPosZ()
	if math.abs(A - R) < 1 then
		return 9
	elseif math.abs(A - R) < 2 then
		return 7.5
	elseif math.abs(A - R) < 3 then
		return 4
	elseif math.abs(A - R) < 4 then
		return 3
	elseif math.abs(A - R) < 5 then
		return 2
	elseif math.abs(A - R) < 6 then
		return 1
	else
		return 0
	end
end

function DistanceCreeper(Receiver, TDI)
	A = TDI.Attacker:GetPosX() + TDI.Attacker:GetPosY() + TDI.Attacker:GetPosZ()
	R = Receiver:GetPosX() + Receiver:GetPosY() + Receiver:GetPosZ()
	if math.abs(A - R) < 1 then
		return 7.5
	elseif math.abs(A - R) < 2 then
		return 5
	elseif math.abs(A - R) < 3 then
		return 2
	elseif math.abs(A - R) < 4 then
		return 1.5
	else
		return 0
	end
end

function ExplodeCreeper( XC, YC, ZC, TDI )
	for XC = -Radius, Radius do
		for YC = -Radius, Radius do
			for ZC = -Radius, Radius do
				Entf = XC*XC + YC*YC + ZC*ZC
				if Entf < Radius*Radius then
					if World:GetBlock( TDI.Attacker:GetPosX() + XC, TDI.Attacker:GetPosY() + YC, TDI.Attacker:GetPosZ() + ZC ) ~= 7 and World:GetBlock( TDI.Attacker:GetPosX() + XC, TDI.Attacker:GetPosY() + YC, TDI.Attacker:GetPosZ() + ZC ) ~= 49 and World:GetBlock( TDI.Attacker:GetPosX() + XC, TDI.Attacker:GetPosY() + YC, TDI.Attacker:GetPosZ() + ZC ) ~= 9 and World:GetBlock( TDI.Attacker:GetPosX() + XC, TDI.Attacker:GetPosY() + YC, TDI.Attacker:GetPosZ() + ZC ) ~= 8 then
						World:DigBlock( TDI.Attacker:GetPosX() + XC, TDI.Attacker:GetPosY() + YC, TDI.Attacker:GetPosZ() + ZC )
					end
				end
			end
		end
	end
end 