function Initialize(Plugin)
	PLUGIN = Plugin
	
	Plugin:SetName("GroupNames")
	Plugin:SetVersion(2)
	
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager.AddHook(cPluginManager.HOOK_CHAT, OnChat);

	return true
end

function OnChat(Player, Message)
	local Group = Player:GetGroups()
	local GroupColor = Group[1]:GetColor() 
	local GroupName = Group[1]:GetName()
	
	local EachPlayer = function( User )
		User:SendMessage(cChatColor.LightGray .. "[" .. GroupName .. "] " .. Player:GetColor() .. Player:GetName() .. cChatColor.LightGray .. ": " .. cChatColor.White .. Message)
	end
	LOGINFO("[" .. GroupName .. "] " .. Player:GetName() .. ": " .. Message)
	Player:GetWorld():ForEachPlayer(EachPlayer)
	return true
end