
BadWords = {}
Warning = ""
Color = ""


function Initialize( Plugin )
	PLUGIN = Plugin
	Plugin:SetName( "NoSwear" )
	Plugin:SetVersion( 2 )
       

	cPluginManager.AddHook(cPluginManager.HOOK_CHAT, OnChat)
	
	LoadConfigFile(PLUGIN:GetLocalDirectory() .. "/Config.ini")
	LoadBadWords(PLUGIN:GetLocalDirectory() .. "/BadWords.txt")
	
	LOG( "Initialized " .. Plugin:GetName() .. " v" .. Plugin:GetVersion() )
	return true
end

function LoadConfigFile(Path)
	local Config = cIniFile()
	Config:ReadFile(Path)
	Warning = Config:GetValueSet( "General", "Warning", "Bad, you may not swear" )
	WarningColor = Config:GetValueSet( "General", "WarningColor", "Rose" )
	Color = GetColor( WarningColor )
	Config:WriteFile(Path)
	if Color == false then
		LOGWARN( "the given color is not valid" )
	end
end

function LoadBadWords(Path)
	local File = io.open(Path)
	if not File then
		LOGWARN( "BadWords.txt is not found. Creating it!" )
		File = io.open(Path, "w" )
		File:write()
		File:close()
	else
		for line in File:lines() do
			table.insert(BadWords, string.upper(line))
		end
		File:close()
	end
end

function OnChat(Player, Message)
	if not Player:HasPermission("NoSwear.Bypass") then
		local ShouldBlockMessage = CheckMessage( string.upper(Message) )	
		if ShouldBlockMessage then
			Player:SendMessage(Color .. Warning)
			return true
		else
			return false
		end
	end
end

function CheckMessage( Message )
	for Idx, word in ipairs(BadWords) do
		if string.find(Message, word) then
			return true
		end
	end
	return false
end

function GetColor( Color )
	local Color = string.lower( Color )
	if Color == "black" then
		return cChatColor.Black
	elseif Color == "navi" then
		return cChatColor.Navi
	elseif Color == "green" then
		return cChatColor.Green
	elseif Color == "blue" then
		return cChatColor.Blue
	elseif Color == "red" then
		return cChatColor.Red
	elseif Color == "purple" then
		return cChatColor.Purple
	elseif Color == "gold" then
		return cChatColor.Gold
	elseif Color == "lightgray" then
		return cChatColor.LightGray
	elseif Color == "gray" then
		return cChatColor.Gray
	elseif Color == "darkpurple" then
		return cChatColor.DarkPurple
	elseif Color == "lightgreen" then
		return cChatColor.LightGreen
	elseif Color == "lightblue" then
		return cChatColor.LightBlue
	elseif Color == "rose" then
		return cChatColor.Rose
	elseif Color == "lightpurple" then
		return cChatColor.LightPurple
	elseif Color == "yellow" then
		return cChatColor.Yellow
	elseif Color == "white" then
		return cChatColor.White
	else
		return false
	end
end