WorldTicks = {}

function Initialize(Plugin)
	PLUGIN = Plugin
	Plugin:SetName("WorldStats")
	Plugin:SetVersion(1)
	
	cPluginManager.AddHook(cPluginManager.HOOK_WORLD_TICK, OnWorldTick)
	
	Plugin:AddWebTab( "World Stats",   HandleRequest_WorldStats )
	return true
end

function HandleRequest_WorldStats(Request)
	local Content = [[
	<form method="POST">
	<input type="submit" value="Refresh" name="Refresh">
	<table border="1">
	<th colspan="2">Server</th>
	<tr>
	<td>Memory Usage</td>
	<td>Num Players</td>
	</tr>
	<tr>
	<td>]] .. cWebAdmin:GetMemoryUsage() .. [[</td>
	<td>]] .. cRoot:Get():GetServer():GetNumPlayers() .. [[</td>
	</tr>
	</table><br />
	<table border="1">
	<th colspan="6">Per World</th>
	<tr>
	<td>World Name</td>
	<td>World Ticks</td>
	<td>World Age</td>
	<td>Num Entitys</td>
	<td>Num Players</td>
	<td>Loaded Chunks</td>
	</tr>]]
	cRoot:Get():ForEachWorld(function(World)
		Content = Content .. [[
		<tr>
		<td>]] .. World:GetName() .. [[</td>
		<td>]] .. WorldTicks[World:GetName()] .. [[</td>
		<td>]] .. World:GetWorldAge() .. [[</td>
		<td>]] .. GetNumEntitysPerWorld(World) .. [[</td>
		<td>]] .. GetNumPlayersPerWorld(World) .. [[</td>
		<td>]] .. World:GetNumChunks() .. [[</td>
		</tr>
	]]
	end)
	Content = Content .. "</table>"
	return Content
end

function OnWorldTick(World, Time)
	WorldTicks[World:GetName()] = Time
end

function GetNumEntitysPerWorld(World)
	local Entitys = 0
	World:ForEachEntity(function(Entity)
		Entitys = Entitys + 1
	end)
	return Entitys
end

function GetNumPlayersPerWorld(World)
	local Players = 0
	World:ForEachPlayer(function(Player)
		Players = Players + 1
	end)
	return Players
end