function Initialize(Plugin)
	PLUGIN = Plugin
	Plugin:SetVersion(1)
	Plugin:SetName("Blocks")
	
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager.AddHook(cPluginManager.HOOK_PLAYER_RIGHT_CLICK, OnPlayerRightClick)
	PluginManager.AddHook(cPluginManager.HOOK_PLAYER_LEFT_CLICK, OnPlayerLeftClick)
	
	if LoadBlocks(PLUGIN:GetLocalDirectory() .. "/Config.ini") == true then
		LOGWARN("Could not load the blocks properly. Plugin is not loaded")
		return false
	end
	LOG("Initialized " .. Plugin:GetName() .. " v" .. Plugin:GetVersion())
	return true
	
end

function LoadBlocks(Path)
	SettingsIni = cIniFile()
	SettingsIni:ReadFile(Path)
	BlockedWorlds = SettingsIni:GetValueSet("General", "ActiveWorlds", cRoot:Get():GetDefaultWorld():GetName())
	Worlds = StringSplit(BlockedWorlds, ",")
	BlockedBlocks = SettingsIni:GetValueSet("General", "Blocks", "46,327,35:6")
	Blocks = StringSplit(BlockedBlocks, ",")
	for I=1, #Blocks do
		if tonumber(Blocks[I]) == nil then
			Block = StringSplit(Blocks[I], ":")
			if #Block == 2 then
				if tonumber(Block[1]) == nil or tonumber(Block[2]) == nil then
					LOGWARN("[" .. PLUGIN:GetName() .. "] Unknown char in " .. Blocks[I])
					return true
				end
				Blocks[I] = {}
				Blocks[I][1] = Block[1]
				Blocks[I][2] = Block[2]
			else
				LOGWARN("[" .. PLUGIN:GetName() .. "] Unknown char in " .. Blocks[I])
				return true
			end
		end
	end
	SettingsIni:WriteFile(Path)
end

function IsInActiveWorld(World)
	if Worlds[1] == nil then
		return true
	end
	for I=1, #Worlds do
		if World:GetName() == Worlds[I] then
			return true
		end
	end
	return false
end


function OnPlayerRightClick(Player, BlockX, BlockY, BlockZ, BlockFace, CursorX, CursorY, CursorZ)
	if Player:HasPermission("blocks.bypass") then
		return false
	end
	if IsInActiveWorld(Player:GetWorld()) == false then
		return false
	end
	Item = Player:GetEquippedItem().m_ItemType
	Meta = Player:GetEquippedItem().m_ItemDamage
	for I=1, #Blocks do
		if Blocks[I][2] ~= nil then
			if tonumber(Blocks[I][1]) == Item and tonumber(Blocks[I][2]) == Meta then
				Player:SendMessage(cChatColor.Rose .. "You are not allowed to place this")
				return true
			end
		else
			if tonumber(Blocks[I]) == Item then
				Player:SendMessage(cChatColor.Rose .. "You are not allowed to place this")
				return true
			end
		end
	end
end

function OnPlayerLeftClick(Player, BlockX, BlockY, BlockZ, BlockFace, CursorX, CursorY, CursorZ)
	if Player:HasPermission("blocks.bypass") then
		return false
	end
	if IsInActiveWorld(Player:GetWorld()) == false then
		return false
	end
	Item = Player:GetWorld():GetBlock(BlockX, BlockY, BlockZ)
	Meta = Player:GetWorld():GetBlockMeta(BlockX, BlockY, BlockZ)
	for I=1, #Blocks do
		if Blocks[I][2] ~= nil then
			if tonumber(Blocks[I][1]) == Item and tonumber(Blocks[I][2]) == Meta then
				Player:SendMessage(cChatColor.Rose .. "You are not allowed to break this")
				return true
			end
		else
			if tonumber(Blocks[I]) == Item then
				Player:SendMessage(cChatColor.Rose .. "You are not allowed to break this")
				return true
			end
		end
	end
end