function HandleRequest_ManageAccs(Request)
	local Content = [[
	<table border="1">
	<tr>
	<td><a href="?tab=Manage_Accounts">Manage Accounts</a></td>
	<td><a href="?tab=Show_Online_Players">Show Online Players</a></td>
	</tr>
	</table><br />
	]]
	if (Request.Params["tab"] == "Manage_Accounts") then
		Content = Content .. WebAdmin_ManageLoginAccounts(Request)
	elseif (Request.Params["tab"] == "Show_Online_Players")then
		Content = Content .. WebAdmin_Show_Online(Request)
	else
		Content = Content .. "<h1>Page not found</h1>"
	end
	return Content
end

function WebAdmin_Show_Online(Request)
	local Content = ""
	if Request.PostParams["Log_Out"] ~= nil then
		cRoot:Get():FindAndDoWithPlayer(Request.PostParams["Log_Out"], function(Player)
			Logout(Player)
			Content = Content .. [[<b style="color: green;">You logged player ]] .. Request.PostParams["Log_Out"] .. [[ out.</b>]]
		end)
	end

	if Request.PostParams["Log_In"] ~= nil then
		cRoot:Get():FindAndDoWithPlayer(Request.PostParams["Log_In"], function(Player)
			Login(Player)
			Content = Content .. [[<b style="color: green;">You logged player ]] .. Request.PostParams["Log_In"] .. [[ in.</b>]]
		end)
	end 
	Content = Content .. [[
	<form method='POST'>
		<table>
			<th colspan="3">There are ]] .. cRoot:Get():GetServer():GetNumPlayers() .. [[ Players online</th>
			<tr>
				<td>Player</td>
				<td>Logged in</td>
				<td>Log out/in</td>
			</tr>
	]]
	cRoot:Get():ForEachPlayer(function(Player)
		local PlayerName = Player:GetName()
		if IsAuthed[PlayerName] then
			Content = Content .. [[
			<tr>
				<td>]] .. PlayerName .. [[</td>
				<td><b style="color: green;">Yes</b></td>
				<td><input type="submit" name="Log_Out" value="Log out"><input type="hidden" value="]] .. PlayerName .. [[" name="Log_Out"></td>
			</tr>]]
		else
			Content = Content .. [[
			<tr>
				<td>]] .. PlayerName .. [[</td>
				<td><b style="color: red;">No</b></td>
				<td><input type="submit" name="Log_In" value="Log in"><input type="hidden" value="]] .. PlayerName .. [[" name="Log_In"></td>
			</tr>]]
		end
	end)
	Content = Content .. [[</table></form>]]
	return Content
end
		
function WebAdmin_ManageLoginAccounts(Request)
	local Content = ""
	local Search = {}
	local Table = PassWords:ReturnTable()

	if Request.PostParams["Search"] ~= nil then
		if Request.PostParams["SearchKey"] ~= "" and Request.PostParams["SearchKey"] ~= nil then
			for I, k in pairs(Table) do
				if string.find(string.upper(I), string.upper(Request.PostParams["SearchKey"])) then
					table.insert(Search, [[
					<tr>
						<td>]] .. I .. [[</td>
						<td><input type='hidden' name='RemoveAcc' value=']] .. I .. [['><input type='submit' name='' value='Delete'></td>
					</tr>]])
				end
			end
		end
	end

	if Request.PostParams["RemoveAcc"] ~= nil then
		PassWords:RemovePlayer(Request.PostParams["RemoveAcc"])
		Content = Content .. '<b style="color: green;">Removed account ' .. Request.PostParams["RemoveAcc"] .. "</b><br />"
	end
	if Request.PostParams["AddAcc"] ~= nil then
		if Request.PostParams["AddAcc_Player"] ~= "" then
			if Request.PostParams["AddAcc_Password"] ~= "" then
				if PassWords:AddPass(Request.PostParams["AddAcc_Player"], Request.PostParams["AddAcc_Password"]) then
					Content = Content .. '<b style="color: green;">Added player ' .. Request.PostParams["AddAcc_Player"] .. "</b>"
				else
					Content = Content .. '<b style="color: red;">The player already exists</b>'
				end
			else
				Content = Content .. '<b style="color: red;">You forgot to add a password</b>'
			end
		else
			Content = Content .. '<b style="color: red;">You forgot to add a playername</b>'
		end
	end
	Content = Content .. [[
		<form method='POST' name='SEARCH'>
			<table>
				<th colspan="2">Search</th>
				<tr>
					<td>Player</td>
					<td>Search</td>
				</tr>
				<tr>
					<td><input type='text' name='SearchKey'></td>
					<td><input type='submit' value='Search' name='Search'></td>
				</tr>]]
		for I, k in pairs(Search) do
			Content = Content .. k
		end
		Content = Content .. [[</table></form>
		<br />
		<form method='POST' name='ADDACC'>
			<table>
				<th colspan="3">Add account</th>
				<tr>
					<td>PlayerName</td>
					<td>Password</td>
					<td>Submit</td>
				</tr><tr>
					<td><input type="text" name="AddAcc_Player"></td>
					<td><input type="password" name="AddAcc_Password"></td>
					<td><input type="submit" value="Add Player" name="AddAcc"></td>
				</tr>
			</table>
		</form>
		<br />
		<form method='POST' name='REMOVEACC'>
			<table>
				<th colspan="2">Remove account</th>
				<tr>
					<td>Player</td>
					<td>RemoveAcc</td>
				</tr>
		]]
	for I, k in pairs(Table) do
		Content = Content .. [[
		<tr>
			<td>]] .. I .. [[</td>
			<td><input type='hidden' name='RemoveAcc' value=']] .. I .. [['><input type='submit' name='' value='Delete'></td>
		</tr>]]
	end
	Content = Content .. [[</table></form>]]
	return Content
end