PLUGIN = nil

AllowedProtocols = {}
KickMessage = ""

function Initialize(Plugin)
	PLUGIN = Plugin
	Plugin:SetName("ProtLimit")
	Plugin:SetVersion(1)
	
	cPluginManager.AddHook(cPluginManager.HOOK_LOGIN, OnLogin)
	
	if not LoadSettings() then
		LOGERROR("ProtLimit: Could not load " .. PLUGIN:GetLocalFolder() .. "/Config.ini")
		return false
	end
	
	LOG("Initialized ProtLimit")
	return true
end


function OnLogin(Client, ProtocolVersion, UserName)
	for Idx, Prot in ipairs(AllowedProtocols) do
		if Prot == ProtocolVersion then
			return false
		end
	end
	
	cRoot:Get():GetDefaultWorld():ScheduleTask(1, function()
		cRoot:Get():FindAndDoWithPlayer(UserName, function(Player)
			if Player:GetName() ~= UserName then
				return false
			end
			Player:GetClientHandle():Kick(KickMessage)
		end)
	end)
	return false
end



function LoadSettings()
	local SettingsIni = cIniFile()
	SettingsIni:ReadFile(PLUGIN:GetLocalFolder() .. "/Config.ini")
	local AllowedProtString = SettingsIni:GetValueSet("General", "AllowedProtocols", 4)
	local RawAllowedProtocols = StringSplitAndTrim(AllowedProtString, ",")
	for Idx, Value in ipairs(RawAllowedProtocols) do
		if tonumber(Value) ~= nil then
			table.insert(AllowedProtocols, tonumber(Value))
		else
			LOGERROR("Protocol version \"" .. Value .. "\" isn't valid. Ignoring")
		end
	end
	
	KickMessage = SettingsIni:GetValueSet("General", "KickMessage", "You do not have the right client version.")
	SettingsIni:WriteFile(PLUGIN:GetLocalFolder() .. "/Config.ini")
	return true
end

	
	
	