g_Plugin = nil
g_SpawnRadius = 0

function Initialize(a_Plugin)
	g_Plugin = a_Plugin
	a_Plugin:SetName("ExplosionSpawnProt")
	a_Plugin:SetVersion(1)
	
	LoadConfig(a_Plugin:GetLocalFolder() .. "/Config.ini")
	
	cPluginManager.AddHook(cPluginManager.HOOK_EXPLODING, OnExploding)
	
	LOG("Initialized ExplosionSpawnProt v" .. a_Plugin:GetVersion())
	return true
end

function LoadConfig(a_Path)
	local IniFile = cIniFile()
	IniFile:ReadFile(a_Path)
	
	g_SpawnRadius = IniFile:GetValueSetI("General", "SpawnRadius", 30)
	
	IniFile:WriteFile(a_Path)
end

function OnExploding(World, ExplosionSize, CanCauseFire, X, Y, Z, Source, SourceData)
	if g_SpawnRadius < 0 then
		return true
	end
	local SpawnX = World:GetSpawnX()
	local SpawnY = World:GetSpawnY()
	local SpawnZ = World:GetSpawnZ()
	local SpawnVector = Vector3d(SpawnX, SpawnY, SpawnZ)
	local ExplosionCoords = Vector3d(X, Y, Z)
	local Distance = (SpawnVector - ExplosionCoords):Length() + ExplosionSize
	if Distance < g_SpawnRadius then
		return true
	end
	return false
end
