LOG = LOG or print

local File = io.open("Input.lua")

if not File then -- File does not exist.
	LOG("Input.lua does not exist.")
	return;
end

local Lines = {}
for Line in File:lines() do
	while Line:sub(1, 1) == " " or Line:sub(1, 1) == "\t" do
		Line = Line:sub(2, Line:len())
	end
	table.insert(Lines, Line)
end
File:close()

function ShouldAddTabs(Line)
	local Function = Line:find("function")
	local If = Line:find("if")
	local For = Line:find("for")
	local Comment = Line:find("--", 1, true)
	if Comment == nil then
		Comment = Line:len() + 1
	end
	if Function ~= nil and Function < Comment then
		return true
	end
	if If ~= nil and If < Comment then
		return true
	end
	if For ~= nil and For < Comment then
		return true
	end
end

local Result = {}
local TabsNeeded = 0
for Idx, Line in pairs(Lines) do
	local UpperLine = string.upper(Line)
	if ShouldAddTabs(Line) then
		table.insert(Result, string.rep("\t", TabsNeeded) .. Line)
		TabsNeeded = TabsNeeded + 1
	elseif Line:find("end") ~= nil and UpperLine:find("SENDMESSAGE") == nil and UpperLine:find("ENDED") == nil then
		TabsNeeded = TabsNeeded - 1
		table.insert(Result, string.rep("\t", TabsNeeded) .. Line)
	elseif Line:find("else") then
		table.insert(Result, string.rep("\t", TabsNeeded - 1) .. Line)
	else
		table.insert(Result, string.rep("\t", TabsNeeded) .. Line)
	end
end

local ResultFile = io.open("Output.lua", "w")
if not ResultFile then
	LOG("Could not open output file.")
	return;
end

-- Write everything to an output file.
for Idx, Line in pairs(Result) do
	ResultFile:write(Line .. "\n")
end
ResultFile:close()

pause()