-- Simple plugin to allow people join even when server is "full"
--[[
v0:
- added per-player slot reservation

v1:
- added per-group slot reservation
]]

-- Global variables
PLUGIN = {}	-- Reference to own plugin object
HANDY = {}	-- here, HANDY candy!
RESERVED_PLAYERS = {}
RESERVED_GROUPS = {}

function Initialize(Plugin)
	PLUGIN = Plugin
	
	PLUGIN:SetName("Slotty")
	PLUGIN:SetVersion(1)
	
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager:AddHook(cPluginManager.HOOK_HANDSHAKE, OnHandshake)
	HANDY = PluginManager:GetPlugin("Handy")
	
	--Plugin:AddWebTab("Snowy", HandleRequest_Snowy)
	LoadSettings(PLUGIN:GetLocalDirectory() .. "/slotty_settings.ini")
	
	LOG("Initialized "..PLUGIN:GetName().." v"..PLUGIN:GetVersion())
	return true
end

function OnDisable()
	LOG(PLUGIN:GetName() .. " v" .. PLUGIN:GetVersion() .. " is shutting down...")
end

function OnHandshake(IN_clienthandle, IN_playername)
	if (RESERVED_PLAYERS[IN_playername] ~= nil) then
		return true
	end
	_ini_file = cIniFile()
	_ini_file:ReadFile("users.ini")
	_groups = _ini_file:GetValue(IN_playername, "Groups")
	_split = LineSplit(_groups, ",")
	for _index = 1, #_split do
		for k,v in pairs(RESERVED_GROUPS) do
			if (_split[_index] == k) then
				return true
			end
		end
	end	
	return false
end

function LoadSettings(Path)
	_ini_file = cIniFile()
	_ini_file:ReadFile(Path)
	for _value_index = 1, _ini_file:GetNumValues("Groups") do
		_group_name = _ini_file:GetValueName("Groups", _value_index-1)
		RESERVED_GROUPS[_group_name] = true
	end
	
	for _value_index = 1, _ini_file:GetNumValues("Players") do
		_player_name = _ini_file:GetValueName("Players", _value_index-1)
		--LOGWARN("Watchout! We've got a badass! ".._player_name.."! Index:".._value_index)
		RESERVED_PLAYERS[_player_name] = true
	end
end

function SaveSettings()		-- RESERVED for possible future web interface
	
end

--|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
-- splits line by any desired symbol
function LineSplit(pString, pPattern)		-- THANK YOU, stackoverflow!
	local Table = {}  -- NOTE: use {n = 0} in Lua-5.0
	local fpat = "(.-)" .. pPattern
	local last_end = 1
	local s, e, cap = pString:find(fpat, 1)
	while s do
		if s ~= 1 or cap ~= "" then
			table.insert(Table,cap)
		end
		last_end = e+1
		s, e, cap = pString:find(fpat, last_end)
	end
	if last_end <= #pString then
		cap = pString:sub(last_end)
		table.insert(Table, cap)
	end
	return Table
end