
-- This file contains all the functions to load/save the tornados





function LoadTornados()
	local File = io.open(g_Plugin:GetLocalFolder() .. "/Tornados.dat")
	if (not File) then
		return false
	end
	
	cRoot:Get():ForEachWorld(
		function(a_World)
			g_Tornados[a_World:GetName()] = {}
		end
	)
	
	for line in File:lines() do
		local Info = StringSplit(line, ",")
		local WorldName, World, RawPos, RawSpeed = Info[1], cRoot:Get():GetWorld(Info[1]), Info[2], Info[3]
		if (World ~= nil) then
			-- Load the coordinates
			local PosCoords = StringSplit(RawPos, ";")
			local Pos = Vector3d(PosCoords[1], 0, PosCoords[2])
			
			-- Load the speed
			local SpeedValues = StringSplit(RawSpeed, ";")
			local Speed = Vector3d(SpeedValues[1], 0, SpeedValues[2])
		
			local Tornado = cTornado(World, Pos, Speed)
			g_Tornados[WorldName] = g_Tornados[WorldName] or {}
			table.insert(g_Tornados[WorldName], Tornado)
		end
	end
	
	if (true) then
		local Tornado = cTornado(cRoot:Get():GetWorld("world"), Vector3d(0, 0, 0))
		table.insert(g_Tornados["world"], Tornado)
	end
	
	return true
end





function SaveTornados()
	local File = io.open(g_Plugin:GetLocalFolder() .. "/Tornados.dat", "w")
	if (not File) then
		return false
	end
	
	-- cRoot:Get():ForEachWorld(
		-- function(a_World)
			-- for Idx, Tornado in ipairs(g_Tornados[a_World:GetName()]) do
				-- Tornado:Save(File)
			-- end
		-- end
	-- )
	for World, Tornados in pairs(g_Tornados) do
		for Idx, Tornado in ipairs(Tornados) do
			Tornado:Save(File)
			Tornados[Idx] = nil
		end
		g_Tornados[World] = nil
	end
	
	File:close()
	return true
end