local random = math.random



-- Implements the cTornado object.





function cTornado(a_World, a_Pos, a_Speed)
	assert(tolua.type(a_World) == "cWorld")
	assert(tolua.type(a_Pos)   == "Vector3<double>")
	
	local m_World = a_World
	local m_Pos = a_Pos
	local m_Speed = a_Speed or Vector3d(random() % random(), 0, random() % random())
	local m_ShouldCreateFallingBlocks = false
	
	m_Pos.y = 128
	
	local self = {}
	
	function self:HandleSpeed()
		m_Pos = m_Pos + m_Speed
		
		m_Speed = m_Speed + Vector3d((random() - random()) / 50, 0, (random() - random()) / 50)
		if (m_Speed.x < -1) then
			m_Speed.x = -1
		elseif (m_Speed.x > 1) then
			m_Speed.x = 1
		end
		
		if (m_Speed.z < -1) then
			m_Speed.z = -1
		elseif (m_Speed.z > 1) then
			m_Speed.z = 1
		end
	end
	
	function self:RipGround()
		if (not m_ShouldCreateFallingBlocks) then
			m_ShouldCreateFallingBlocks = true
			return
		end
		
		local MinX, MaxX = m_Pos.x - 10, m_Pos.x + 10
		local MinZ, MaxZ = m_Pos.z - 10, m_Pos.z + 10
		
		for X = MinX, MaxX do
			for Z = MinZ , MaxZ do
				if (random(250) == 1) then
					local Succes, Height = m_World:TryGetHeight(X, Z)
					if (Succes) then
						local IsValid, BlockType, BlockMeta = m_World:GetBlockTypeMeta(X, Height, Z)
						m_World:DigBlock(X, Height, Z)
						local EntID = m_World:SpawnFallingBlock(X, Height + 1.5, Z, BlockType, BlockMeta)
						-- m_World:DoWithEntityByID(EntID,
							-- function(a_Entity)
								-- a_Entity:SetSpeedY(25)
							-- end
						-- )
					end
				end
			end
		end
	end
	
	function self:PullEntities()
		local MinX, MaxX = (m_Pos.x - 10) / 16 - 1, (m_Pos.x + 10) / 16 + 1
		local MinZ, MaxZ = (m_Pos.z - 10) / 16 - 1, (m_Pos.z + 10) / 16 + 1
		
		local Callback = function(a_Entity)
			if (a_Entity:GetSpeed():Length() < 50) then
				local EntityPos = Vector3d(a_Entity:GetPosition())
				EntityPos.y = 128
				local Direction = m_Pos - EntityPos
				local Distance = Direction:Length()
				if (Distance < 4) then
					a_Entity:AddSpeed(Vector3d(random(-10, 10), 2, random(-10, 10)))
				elseif (Distance < 50) then
					Direction:Normalize()
					a_Entity:AddSpeed(Direction * ((50 - Distance) / 5))
				end
			end
		end
		
		for X = MinX, MaxX do
			for Z = MinZ, MaxZ do
				m_World:ForEachEntityInChunk(X, Z, Callback)
			end
		end
	end
	
	function self:Tick(a_World)
		if (not self:FindPlayerCloseEnough()) then
			return
		end
		
		local Succes, Height = m_World:TryGetHeight(m_Pos.x, m_Pos.z)
		if (not Succes) then
			return
		end
		
		-- print(m_Pos.x, m_Pos.z)
		self:HandleSpeed()
		self:RipGround()
		self:PullEntities()
		for Y = Height, 128 do
			m_World:BroadcastParticleEffect("smoke", m_Pos.x, Y, m_Pos.z, random()*random(), random()*random(), random()*random(), 0.5, 15)
			-- m_World:BroadcastSoundParticleEffect(2000, m_Pos.x, Y, m_Pos.z, 4)
		end
	end
	
	function self:Save(a_File)
		a_File:write(m_World:GetName(), ",", m_Pos.x, ";", m_Pos.z, ",", m_Speed.x, ";", m_Speed.z, "\n")
	end
	
	function self:FindPlayerCloseEnough()
		local FoundPlayer = false
		m_World:ForEachPlayer(
			function(a_Player)
				if ((m_Pos - a_Player:GetPosition()):Length() < 150) then
					FoundPlayer = true
					return true
				end
			end
		)
		return FoundPlayer
	end
	
	return self
end
