
-- Change these values to a desired destination in the Minecraft universe --
-- ////////////////////////////////////////////////////////////////////// --

local LoginX = 0
local LoginY = 75
local LoginZ = 0
local LoginWorld = "world"

-- ////////////////////////////////////////////////////////////////////// --

PLUGIN = nil

PlayerJoinQueue = {}

function Initialize(Plugin)
	PLUGIN = Plugin

	Plugin:SetName("LoginTeleport")
	Plugin:SetVersion(1)

	cPluginManager:AddHook(cPluginManager.HOOK_PLAYER_JOINED, OnPlayerJoined)
	cPluginManager:AddHook(cPluginManager.HOOK_TICK, OnTick)

	LOG("Initialized LoginTeleport!")

	return true
end

function OnPlayerJoined(Player)
	table.insert(PlayerJoinQueue, Player:GetName())
end

function OnTick(TimeDelta)
	for _, k in pairs(PlayerJoinQueue) do
		LOG(k)
		cRoot:Get():FindAndDoWithPlayer(k, function(Player)
			if Player:GetWorld():GetName() ~= LoginWorld then
				Player:MoveToWorld(LoginWorld, false)
			else
				Player:TeleportToCoords(LoginX, LoginY, LoginZ)
				table.remove(PlayerJoinQueue, _)
			end
		end
		)
	end
end
