function Initialize(Plugin)
	Plugin:SetName(g_PluginInfo.Name)
	Plugin:SetVersion(g_PluginInfo.Version)

	dofile(cPluginManager:GetPluginsPath() .. "/InfoReg.lua")
	RegisterPluginInfoCommands()

	LOG("Initialised " .. Plugin:GetName() .. " v." .. Plugin:GetVersion())
	return true
end

function HandleCommandBlockCommand(Split, Player)
	local SetCommand = function(CommandBlock)
		local ChangeCommand = tolua.cast(CommandBlock, "cCommandBlockEntity")
		CommandBlock:SetCommand(table.concat(Split, " ", 3))
	end

	local GetOutput = function(CommandBlock)
		local ChangeCommand = tolua.cast(CommandBlock, "cCommandBlockEntity")
		Output = CommandBlock:GetLastOutput()
	end

	local LookPos = GetPlayerLookPos(Player)

	if Split[2] == "set" then
		if not Player:GetWorld():DoWithBlockEntityAt(LookPos.x, LookPos.y, LookPos.z, SetCommand) then
			Player:SendMessageInfo("You have to look at a command block to set its command")
		else
			Player:SendMessageSuccess("Successfully set command for command block. Activate it with redstone, and type \"/commandblock result\" while looking at the command block to see its result")
		end
	elseif Split[2] == "result" then
		if not Player:GetWorld():DoWithBlockEntityAt(LookPos.x, LookPos.y, LookPos.z, GetOutput) then
			Player:SendMessageInfo("You have to look at a command block to get its result")
		else
			Player:SendMessage(cChatColor.Bold .. "The result of the command block:")
			Player:SendMessage(Output)
		end
	else
		Player:SendMessageInfo("Usage: " .. Split[1] .. " <set|result> [command ...]")
	end
	return true
end

function OnDisable()
	LOG("Disabled " .. cPluginManager:GetCurrentPlugin():GetName() .. "!")
end
