homeDir = 'Plugins/WorldBorder'

function Initialize(Plugin)
	Plugin:SetName("WorldBorder")
	Plugin:SetVersion(1)
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager:BindCommand("/wb","*",HandleWbCommand," ~ Set World Border!")
	cPluginManager.AddHook(cPluginManager.HOOK_PLAYER_MOVING, OnPlayerMoving)
	LOGINFO("Initialized " .. Plugin:GetName() .. " v." .. Plugin:GetVersion() .. " by Dredd")
	if not file_exists(homeDir..'/worlds.cfg') then
	LOG('Config not found! Create default...')
	local file = io.open(homeDir..'/worlds.cfg', "w")
	file:write('1000\n1000\n1000')
	file:close()
	end
	getConfig()
	LOG('Config loaded, World set-'..worldb..', Nether set-'..netherb..' End set-'..endb)
return true
end

function getConfig()
	conf = lines_from(homeDir..'/worlds.cfg')
	worldb = conf[1]
	netherb = conf[2]
	endb = conf[3]
return true
end

function file_exists(file)
	local f = io.open(file, "rb")
	if f then f:close() end
	return f ~= nil
end

function lines_from(file)
	if not file_exists(file) then return {} end
	lines = {}
	for line in io.lines(file) do 
	lines[#lines + 1] = line
	end
	return lines
end

function HandleWbCommand(Split, Player)
	if Split[2] == nil then
	Player:SendMessage(cChatColor.Green..'[INFO] /wb [world] [radius]')
	Player:SendMessage(cChatColor.Green..'[INFO]'..cChatColor.White..' Worlds set:')
	Player:SendMessage(cChatColor.Green..'[INFO]'..cChatColor.White..' World = '..worldb)
	Player:SendMessage(cChatColor.Green..'[INFO]'..cChatColor.White..' World_Nether = '..netherb)
	Player:SendMessage(cChatColor.Green..'[INFO]'..cChatColor.White..' World_the_End = '..endb)
	else
		wbworld = Split[2]
		if wbworld ~= 'world' and wbworld ~= 'world_nether' and wbworld ~= 'world_the_end' or Split[3] == nil or not tonumber(Split[3], 10) or tonumber(Split[3], 10) < 10 then
		Player:SendMessage(cChatColor.Green..'[INFO]'..cChatColor.White..' Wrong parameter! Use ' .. cChatColor.Green ..'/wb [world] [radius]')
		else
		local file = io.open(homeDir..'/worlds.cfg', "w")
		wbRadius = Split[3]
			if wbworld == 'world' then
			file:write(wbRadius..'\n'..netherb..'\n'..endb)
			elseif wbworld == 'world_nether' then
			file:write(worldb..'\n'..wbRadius..'\n'..endb)
			else
			file:write(worldb..'\n'..netherb..'\n'..wbRadius)
			end
		file:close()
		Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' World border ' .. cChatColor.Green .. wbworld.. cChatColor.White .. ' set ' .. cChatColor.Green .. wbRadius .. cChatColor.White .. ' from Spawn!')
		getConfig()
		end
	end
return true
end

function OnPlayerMoving(Player)
	nowX = math.ceil(Player:GetPosX())
	nowY = math.ceil(Player:GetPosY())
	nowZ = math.ceil(Player:GetPosZ())
	nowW = Player:GetWorld():GetName()
	spawnX = Player:GetWorld():GetSpawnX()
	spawnZ = Player:GetWorld():GetSpawnZ()
	nowR = math.ceil(math.sqrt((nowX - spawnX)^2 + (nowZ - spawnZ)^2))
	if (nowR) > tonumber(worldb) then
	if nowX > spawnX then newX = nowX - 3 else newX = nowX + 3 end
	if nowZ > spawnZ then newZ = nowZ - 3 else newZ = nowZ + 3 end
	newY = nowY + 2
	Player:TeleportToCoords(newX,newY,newZ)
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' You have reached the edge of the World, come back closer to Spawn...')
	Player:GetWorld():BroadcastSoundEffect("entity.ghast.shoot",Vector3d(newX,newY,newZ),1,1)
	Player:GetWorld():BroadcastParticleEffect("magiccrit",Vector3f(nowX,nowY,nowZ),Vector3f(2,2,2),1,500)
	return true
	end
return false
end