function Initialize(a_Plugin)
	a_Plugin:SetName("Elevator");
	a_Plugin:SetVersion(3);
	cPluginManager:AddHook(cPluginManager.HOOK_PLAYER_MOVING, JugadorSalta);
	cPluginManager:AddHook(cPluginManager.HOOK_PLAYER_CROUCHED, JugadorAgacha);
	LOGINFO("Initialized " .. a_Plugin:GetName() .. " v." .. a_Plugin:GetVersion() .. "")
	return true;
end

function JugadorSalta(Player, OldPosition, NewPosition, PreviousIsOnGround)
		a_Delta = OldPosition - NewPosition;
		if (a_Delta.y < 0) then
			if Player:GetWorld():GetBlock(Vector3i(OldPosition.x, OldPosition.y-1, OldPosition.z)) == E_BLOCK_WOOL then
				if PreviousIsOnGround == true then
					for i = OldPosition.y, Player:GetWorld():GetHeight(OldPosition.x, OldPosition.z), 1 do
						if Player:GetWorld():GetBlock(Vector3i(OldPosition.x, i, OldPosition.z)) == E_BLOCK_WOOL then
							Player:TeleportToCoords(OldPosition.x, i+1, OldPosition.z)
							Player:SendMessage(cChatColor.Green..'Lift UP')
							Player:GetWorld():BroadcastSoundEffect("block.piston.extend",Vector3d(OldPosition.x, i+1, OldPosition.z),1,1)
							return true
						end
					end
				end
			end
		end
	return false
end

function JugadorAgacha(Player)
	OldPosition = Player:GetPosition()
	if Player:GetWorld():GetBlock(Vector3i(OldPosition.x, OldPosition.y-1, OldPosition.z)) == E_BLOCK_WOOL then
		local i = OldPosition.y-2
		while i >= 3 do
			if Player:GetWorld():GetBlock(Vector3i(OldPosition.x, i, OldPosition.z))	== E_BLOCK_WOOL then
				Player:TeleportToCoords(OldPosition.x, i+1, OldPosition.z)
				Player:SendMessage(cChatColor.Green..'Lift DOWN')
				Player:GetWorld():BroadcastSoundEffect("block.piston.contract",Vector3d(OldPosition.x, i+1, OldPosition.z),1,1)
				return true
			end
			i = i - 1
		end
	end
end

function OnDisable()
    LOG('Disabling...')
end