homeDir = 'Plugins/SimpleHome'

function Initialize(Plugin)
	Plugin:SetName("SimpleHome")
	Plugin:SetVersion(2)
	PluginManager = cRoot:Get():GetPluginManager()
	PluginManager:BindCommand("/home","simplehome.home",HandleHomeCommand," - Teleport to your home")
	PluginManager:BindCommand("/sethome","simplehome.sethome",HandleSetHomeCommand," - Set your home")
	PluginManager:BindCommand("/gohome","simplehome.gohome",HandleUserHomeCommand," ~ Teleport to other player home")
	LOGINFO("Initialized " .. Plugin:GetName() .. " v." .. Plugin:GetVersion() .. "")
	return true;
end

function HandleHomeCommand(Split, Player)
	goHome(Player)
	return true
end

function HandleSetHomeCommand(Split, Player)
	setHome(Player)
	return true
end

function goHome(Player)
	username = Player:GetName()
	thisworld = Player:GetWorld():GetName()
	coords = lines_from(homeDir..'/'..username..'_'..thisworld..'.home')
	if file_exists(homeDir..'/'..username..'_'..thisworld..'.home')
	then
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Wellcome to home!')
	Player:TeleportToCoords(coords[1], coords[2], coords[3])
	Player:GetWorld():BroadcastSoundEffect("entity.player.levelup",Vector3d(coords[1], coords[2], coords[3]),1,1)
	else
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' You not have home in this world, '..cChatColor.Green ..'/sethome'.. cChatColor.White ..' for create.')
	end
	return true
end

function setHome(Player)
	username = Player:GetName()
	thisworld = Player:GetWorld():GetName()
	if thisworld == "world_the_end"
	then
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Denied in this world!')
	else
	homeX = Player:GetPosX()
	homeY = Player:GetPosY()
	homeZ = Player:GetPosZ()
	LOGINFO('/sethome was executed by player '..username..' in '..thisworld..' ('..homeX..', '..homeY..', '..homeZ..')')
	local file = io.open(homeDir..'/'..username..'_'..thisworld..'.home', "w")
	file:write(homeX..'\n'..homeY..'\n'..homeZ)
	file:close()
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Home set,' .. cChatColor.Green .. ' /home' .. cChatColor.White .. ' to go home.')
	end
	return true
end

function HandleUserHomeCommand(Split, Player)
	if Split[2] ~= nil then
	tPlayer = Split[2]
		if file_exists(homeDir..'/'..tPlayer..'_'..thisworld..'.home') then
			thisworld = Player:GetWorld():GetName()
			coords = lines_from(homeDir..'/'..tPlayer..'_'..thisworld..'.home')
			Player:TeleportToCoords(coords[1], coords[2], coords[3])
			Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Wellcome to ' .. tPlayer .. '\'s home!')
			Player:GetWorld():BroadcastSoundEffect("entity.player.levelup",Vector3d(coords[1], coords[2], coords[3]),1,1)
		else
		Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Home not found!' .. cChatColor.Green .. ' /gohome [player]')
		end
	else
	Player:SendMessage(cChatColor.Green .. '[INFO]' .. cChatColor.White .. ' Input name!' .. cChatColor.Green .. ' /gohome [player]')
	end
return true
end

function file_exists(file)
	local f = io.open(file, "rb")
	if f then f:close() end
	return f ~= nil
end

function lines_from(file)
	if not file_exists(file) then return {} end
	lines = {}
	for line in io.lines(file) do 
	lines[#lines + 1] = line
	end
	return lines
end

function OnDisable()
    LOG('Disabling...')
end